package cn.com.duiba.kjy.api.remoteservice.explosioncontent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.explosionContent.ExplosionContentDto;
import cn.com.duiba.kjy.api.dto.explosionContent.ExplosionContentExtDto;
import cn.com.duiba.kjy.api.dto.explosionContent.RecommendSeeDto;

import java.util.Date;
import java.util.List;
import cn.com.duiba.kjy.api.params.PageQuery;
import org.apache.commons.lang.BooleanUtils;

/**
 * @Author chentiecheng
 * @Date 2020/1/6 7:42 下午
 */
@AdvancedFeignClient
public interface RemoteExplosionContentService {

    /**
     * 从文章管理新增或者更新爆款素材
     * @param explosionContentDto
     * @return
     */
    Boolean addOrUpdateExplosionContent(ExplosionContentExtDto explosionContentDto);


    /**
     * 根据文章id 删除爆款/必转素材
     *
     * @param contentId
     * @return
     */
    Integer deleteExplosionContentId(Long contentId);

    /**
     * 根据id查询爆款素材
     * @param id
     * @return
     */
    ExplosionContentDto selectById(Long id);

    /**
     * 分页查询爆款素材列表
     * @param pageQuery
     * @return
     */
    List<ExplosionContentDto> selectPageByContentIdNotNull(PageQuery pageQuery);

    /**
     * 查询爆款文章总数
     * @return
     */
    Long selectCountByContentIdNotNull();

    /**
     * 同步文章
     * @param explosionContentDto
     * @return
     */
    Boolean syncExplosion(ExplosionContentExtDto explosionContentDto);

    /**
     * 从爆款文章列表 编辑爆款文章
     * @param explosionContentDto
     * @return
     */
    Boolean updateExplosion(ExplosionContentDto explosionContentDto);

    /**
     * 根据文章id查询爆款素材
     * @param contentId
     * @return
     */
    ExplosionContentDto selectByContentId(Long contentId);

    /**
     * 根据收藏id查询爆款素材
     * @param collectionId
     * @return
     */
    ExplosionContentDto selectByCollectionId(Long collectionId);

    /**
     * 获取必转素材
     * @return
     */
    ExplosionContentDto selectBehooveContent();

    /**
     * 获取必转素材
     * @return
     */
    ExplosionContentExtDto selectMustTurnContent();

    /**
     * 根据id 删除爆款素材
     * @param id
     * @return
     */
    Boolean deleteExplosionContent(Long id);

    /**
     * 查询推荐你看列表
     *
     * @return
     */
    @Deprecated
    List<RecommendSeeDto> queryRecommendSeeList(Long contentId);
    /**
     * 查询推荐你看列表
     *
     * @return
     */
    List<RecommendSeeDto> queryRecommendSeeListByPageSize(Long contentId,Integer pageSize);

    /**
     * 根据文章id列表 批量删除爆款素材
     * @param contentIds
     * @return
     */
    Integer batchDeleteByContentIds(List<Long> contentIds);

    /**
     * 首页-获取爆款列表(只支持分页查询前10篇)
     * @param pageQuery
     * @return
     */
    List<ExplosionContentDto> selectExplosionContentList(PageQuery pageQuery);


    /**
     * 保险专业版: 首页-获取爆款列表(只支持分页查询前10篇)
     * 通用版: 首页-获取爆款列表,只展示通用版素材前10篇
     * @param pageQuery
     * @return
     */
    List<ExplosionContentDto> selectExplosionContentListOnDifferentVersion(PageQuery pageQuery,Integer version);

    /**
     * 首页-获取必转内容
     * @return
     */
    ExplosionContentDto selectShareContent();

    /**
     * 获取contentIds中为爆款素材的内容id
     * @param contentIds
     * @return
     */
    List<Long> getExplosionContentIds(List<Long> contentIds);

    /**
     * 定时发布爆款素材
     * @param dto
     * @return
     */
    Boolean openTimingExplosion(ExplosionContentExtDto dto);


    /**
     * 更新必转素材
     * @param explosionContentExtDto
     * @return
     */
    Boolean updateMustTurnContent(ExplosionContentExtDto explosionContentExtDto);

    /**
     * 判断当前时间是否存在定时的必转文章
     * @param date
     * @return
     */
    Boolean existBehooveContent(Date date);

    /**
     * 根据收藏id删除爆款素材
     * @param collectionId
     * @return
     */
    Integer deleteExplosionByCollectionIdAndType(Long collectionId, Integer type);
}
