package cn.com.duiba.kjy.api.remoteservice.invitationLetter;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.invitationLetter.InvitationLetterStatisticDto;

import java.util.List;

/**
 * 邀请函统计rpc接口
 * @author 吴文哲
 * @date 2020-02-19 13:51
 **/
@AdvancedFeignClient
public interface RemoteInvitationLetterStatisticService {
    /**
     * 根据配置id  查找邀请函统计信息
     * @param confIds
     * @return
     */
    List<InvitationLetterStatisticDto> getStatisticByConfIds(List<Long> confIds);

    /**
     * 新增统计记录 并追加访问数量
     * @param configId
     * @return
     */
    Integer addStatisticAndAddVisitNum(Long configId);

    /**
     * 根据配置id 获取统计信息
     * @param confId
     * @return
     */
    InvitationLetterStatisticDto getStatisticByConfId(Long confId);

    /**
     * 更新统计记录中 接受邀请的统计信息
     * @param confId
     * @return
     */
    Integer updateStatisticAcceptNum(Long confId);
}
