package cn.com.duiba.kjy.api.params.pay;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author lizhi
 * @date 2020/1/8 10:50 AM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WxCompanyPayRecordParam extends PageQuery {

    private static final long serialVersionUID = -7613284066672521490L;

    /**
     * 申请商户号的appid或商户号绑定的appid
     */
    private String mchAppId;

    /**
     * 商户订单号
     */
    private String partnerTradeNo;

    /**
     * 状态：0-创建成功,1-处理中,2-转账成功,3-转账失败
     */
    private Integer payStatus;

    /**
     * 企业付款成功，返回的微信付款单号
     */
    private String paymentNo;

    /**
     * 使用企业付款的业务类型
     */
    private Integer companyPayBizType;

    /**
     * 使用企业付款业务对应表的主键
     */
    private Long companyPayBizId;
}
