package cn.com.duiba.kjy.api.dto.invitationLetter;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 销售员邀请函配置表
 * @author kjj mybatis generator 
 * 2020-02-18
 */
@Data
public class InvitationLetterConfDto implements Serializable {
    private static final long serialVersionUID = 15820119616442468L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *邀请函ID，对应tb_content.id
     * not null default = null
     */
    private Long contentId;

    /**
     *
     *代理人邀请函id，对应tb_seller_content.id
     * not null default = 0
     */
    private Long scid;

    /**
     *
     *销售员id，对应tb_seller.id
     * not null default = null
     */
    private Long sellerId;

    /**
     *
     *标题/主题
     * max length = 100
     * not null default = null
     */
    private String title;

    /**
     *
     *邀请函主图
     * max length = 255
     */
    private String mainUrl;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     *
     *邀请函内容
     * not null default = null
     */
    private String invitationInfo;
}