package cn.com.duiba.kjy.api.enums.seller;

/**
 * 分销类型
 * @author zhanghuifeng
 * date 2019-06-18-11:04
 */
public enum DistributionTypeEnum {

    ORDINARY(1, "普通邀请"),
    SP(2, "会销邀请"),
    ;
    private Integer code;

    private String desc;

    DistributionTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static DistributionTypeEnum getByCode(Integer code) {
        for (DistributionTypeEnum enumVal : DistributionTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (DistributionTypeEnum enumVal : DistributionTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
