package cn.com.duiba.kjy.api.params.content;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by dugq on 2019-11-15.
 */
@Data
public class ArticleListParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = -551416442560660922L;

    /**
     * 收藏状态
     * @see cn.com.duiba.kjy.api.enums.content.AdminCollectionStatusEnum
     */
    private Byte articleStatus;
    /**
     * 时间（yyyy-MM-dd）
     */
    private Date time;
    /**
     * 操作人
     */
    private String operator;
    /**
     * 一级标签
     */
    private Long firstTag;
    /**
     * 二级标签
     */
    private Long secondTag;
    /**
     * url
     */
    private String sourceUrlMd5;

    private List<Long> ids;
    /**
     * 爬虫库文章ID
     */
    private Long grabContentId;
    /**
     * 文章库文章ID
     */
    private Long contentId;
    /**
     * 开始时间
     */
    private Date startTime;
    /**
     * 结束时间
     */
    private Date endTime;

}
