package cn.com.duiba.kjy.api.remoteservice.fission;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.fission.FissionAwardContextDto;
import cn.com.duiba.kjy.api.dto.fission.FissionChatRecordDto;
import cn.com.duiba.kjy.api.params.fission.FissionChatMessageParam;

import java.util.List;

/**
 * 远程裂变聊天记录服务
 * @author : liuchao1@duiba.com.cn
 * @version V1.0
 * @date 2019年10月31日 19:08
 **/
@AdvancedFeignClient
public interface RemoteFissionChatRecordService {

    /**
     * 保存
     * @param dto
     * @return
     */
    FissionChatRecordDto save(FissionChatRecordDto dto);

    /**
     * 根据活动id与接收者用户id查询
     * @param activityId 活动id
     * @param senderUserId 发送者用户id
     * @param receiveUserId 接受者用户id
     * @return
     */
    List<FissionChatRecordDto> findByActivityAndUserIds(Long activityId, Long senderUserId, Long receiveUserId);

    /**
     * 获取全部的消息
     * @param activityId
     * @param partakeRecordId
     * @param receiverUserId
     * @param senderUserId 发送者用户id
     * @return
     */
    List<FissionChatRecordDto> getAllChatRecords(Long activityId, Long partakeRecordId, Long receiverUserId, Long senderUserId);

    /**
     * 更新未读消息为已读消息
     * @param activityId 活动id
     * @param receiveUserId 接收人id
     * @param senderUserId 用户id
     * @param lastId 最后一条消息id
     * @return
     */
    Boolean readed(Long activityId, Long receiveUserId, Long senderUserId, Long lastId);

    /**
     * 获取下一阶段的消息
     * @param activityId 活动id
     * @param partakeRecordId 裂变参与id
     * @param scencType 场景类型
     * @param lastId 最后一条消息id
     * @param receiveUserId 接受者用户id
     * @return
     */
    List<FissionChatRecordDto> getNextMsg(Long activityId, Long partakeRecordId, String scencType, Long lastId, Long receiveUserId);

    /**
     * 根据会话流程flowId修改接收者用户id
     * @param receiveUserId
     * @param flowId
     * @return
     */
    Boolean updateReceiveUserIdByFlowId(Long receiveUserId, String flowId);

    /**
     * 根据用户id查询
     * @param id
     * @return
     */
    FissionChatRecordDto findById(Long id);

    /**
     * 根据参数统计未读的消息数量
     * @param activityId 活动id
     * @param receiveUserId 接受者用户id
     * @param sendUserId 发送者用户id
     * @param chatType 聊天类型，不传统计全部类型
     * @return
     */
    Integer countUnReadMsg(Long activityId, Long receiveUserId, Long sendUserId, Integer chatType);

    /**
     * 发送消息
     * @param message
     * @return
     */
    Boolean sendMsg(FissionChatMessageParam message);

    /**
     * 代理人获取某个用户的聊天记录
     * @param activityId 活动id
     * @param sellerUserId 代理人用户id
     * @param uid 用户id
     * @return
     */
    List<FissionChatRecordDto> getSellerMessage(Long activityId, Long sellerUserId, Long uid);

    /**
     * 获取首条消息，参与或者助力
     * @param activityId 活动id
     * @param partakeRecord 裂变参与id
     * @return
     */
    FissionAwardContextDto getFirstMessage(Long activityId, Long partakeRecord);
}
