package cn.com.duiba.kjy.api.remoteservice.invitationLetter;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.invitationLetter.InvitationLetterRecordDto;
import cn.com.duiba.kjy.api.params.invitationLetter.InvitationLetterRecordParam;

import java.util.List;

/**
 * 邀请函记录rpc接口
 * @author 吴文哲
 * @date 2020-02-19 13:50
 **/
@AdvancedFeignClient
public interface RemoteInvitationLetterRecordService {

    /**
     * 根据配置id  访客id 获取访问记录
     * @param confId
     * @param visitorId
     * @return
     */
    InvitationLetterRecordDto getRecordByConfIdAndVisitorId(Long confId, Long visitorId);

    /**
     * 新增查看访问记录
     * @param dto
     * @return
     */
    Integer addViewRecord(InvitationLetterRecordDto dto);

    /**
     * 根据条件查询总数
     * @param param
     * @return
     */
    Integer countRecordByCondition(InvitationLetterRecordParam param );

    /**
     * 根据条件分页查询列表
     * @param param
     * @return
     */
    List<InvitationLetterRecordDto> getRecordListByCondition(InvitationLetterRecordParam param );

    /**
     * 记录标记为已读
     * @param recordId
     * @return
     */
    Boolean readMark(Long recordId);

    /**
     * 更新邀请函访问记录数据
     * @param dto
     * @return
     */
    Integer updateInvitationLetterRecord(InvitationLetterRecordDto dto);
}
