package cn.com.duiba.kjy.api.remoteservice.privatechat;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.privatechat.ChatContentDto;
import cn.com.duiba.kjy.api.dto.privatechat.ChatContentHistoryListDto;
import cn.com.duiba.kjy.api.dto.privatechat.ChatContentListDto;
import cn.com.duiba.kjy.api.dto.privatechat.ChatContentNewListDto;
import cn.com.duiba.kjy.api.dto.privatechat.CheckUnreadDto;
import cn.com.duiba.kjy.api.dto.privatechat.PrivateChatRecordSimpleDto;
import cn.com.duiba.kjy.api.dto.privatechat.SellerLinkmanDto;
import cn.com.duiba.kjy.api.dto.privatechat.UserLinkmanDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.privatechat.ChatHistoryParam;
import cn.com.duiba.kjy.api.params.privatechat.ChatListParam;
import cn.com.duiba.kjy.api.params.privatechat.ChatNewsParam;
import cn.com.duiba.kjy.api.params.privatechat.ChatReadedParam;
import cn.com.duiba.kjy.api.params.privatechat.ChatSendParam;
import cn.com.duiba.kjy.api.params.privatechat.CheckUnreadParam;

import java.util.Date;
import java.util.List;


/**
 * 私信接口
 * @Auther: Tt(yehuawei)
 * @Date: 2019/6/28 0028 14:23
 */
@AdvancedFeignClient
public interface RemotePrivateChatService {
    /**
     * 内容页-查询是否存在未读消息
     * @param checkUnreadParam
     * @return
     */
    CheckUnreadDto checkUnread(CheckUnreadParam checkUnreadParam);

    /**
     * 聊天页-发送消息
     * @param chatSendParam
     * @return
     */
    Boolean send(ChatSendParam chatSendParam);

    /**
     * 批量发送 (批量发送最大条数小于refreshConstant.privateChatBatchSendSize)
     * @param chatSendParam
     * @return
     */
    Integer batchSend(ChatSendParam chatSendParam);

    /**
     * 批量发送 (批量发送最大条数小于refreshConstant.privateChatBatchSendSize)返回id
     * @param chatSendParam
     * @return
     */
    List<Long> batchSendBackIds(ChatSendParam chatSendParam);

    /**
     * 聊天页-首次获取聊天内容
     * @param chatListParam
     * @return
     */
    ChatContentListDto list(ChatListParam chatListParam);

    /**
     * 聊天页-下拉获取历史聊天记录
     * @param chatHistoryParam
     * @return
     */
    ChatContentHistoryListDto history(ChatHistoryParam chatHistoryParam);

    /**
     * 聊天页-获取最新消息
     * @param chatNewsParam
     * @return
     */
    ChatContentNewListDto news(ChatNewsParam chatNewsParam);

    /**
     * 聊天页-消息已读
     * @param chatReadedParam
     * @return
     */
    Boolean readed(ChatReadedParam chatReadedParam);

    /**
     * 聊天列表-客户获取联络人列表
     * @return
     */
    Page<UserLinkmanDto> userLinkmanList(Long userId,Integer pageIndex, Integer pageSize);

    /**
     * 聊天列表-代理人获取联络客户列表
     * @return
     */
    Page<SellerLinkmanDto> sellerLinkmanList(Long sellerId,Integer pageIndex, Integer pageSize);

    /**
     * 聊天列表-代理人未读消息总数
     * @return
     */
    Integer sellerUnreadCount(Long sellerId);

    /**
     * 聊天列表-代理人未读消息最后一条未读消息的接收时间
     * @param sellerId
     * @return
     */
    Date findLastUnreadMsgDate(Long sellerId);

    /**
     * 根据主键获取
     * @param id
     * @return
     */
    ChatContentDto getById(Long id);

    /**
     * 查询当天的代理人与用户的聊天记录(线索1.0使用)
     * @param sellerId
     * @param custUserId
     * @param startId
     * @param date
     * @return
     */
    @Deprecated
    List<ChatContentDto> getClueChatContent(Long sellerId, Long custUserId, Long startId, Date date);

    /**
     * 查询当天的代理人与用户的limitNum条聊天记录(线索1.0使用)
     * @param sellerId
     * @param custUserId
     * @param startId
     * @param date
     * @param limitNum
     * @return
     */
    List<ChatContentDto> getLimitClueChatContent(Long sellerId, Long custUserId, Long startId, Date date, Integer limitNum);

    /**
     * 查询聊天总数(线索1.0使用)
     * @param sellerId
     * @param custUserId
     * @param startId
     * @param date
     * @return
     */
    Integer countClueChatContent(Long sellerId, Long custUserId, Long startId, Date date);

    /**
     * 向上寻找limitNum的当天记录
     * @param sellerId
     * @param custUserId
     * @param limitNum
     * @return
     */
    List<PrivateChatRecordSimpleDto> findTodayLastMsgs(Long sellerId, Long custUserId, Integer limitNum);

}
