package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerContentCustomDto;

/**
 * 代理人自定义文章rpc服务
 * @author 吴文哲
 * @date 2020-03-03 16:18
 **/
@AdvancedFeignClient
public interface RemoteSellerContentCustomService {

    /**
     * 新增
     * @param sellerContentCustomDto
     * @return
     */
    Integer addCustomDto(SellerContentCustomDto sellerContentCustomDto);

    /**
     * 更新
     * @param sellerContentCustomDto
     * @return
     */
    Integer updateCustomDto(SellerContentCustomDto sellerContentCustomDto);

    /**
     * 根据scid查询自定义素材内容
     * @param scid
     * @return
     */
    SellerContentCustomDto findByScid(Long scid);

    /**
     * 根据主键id查找
     * @param id
     * @return
     */
    SellerContentCustomDto findById(Long id);


}
