/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.user;

import java.util.HashMap;
import java.util.Map;

public enum WxMsgTypeEnum {
    TEXT("text", "\u6587\u672c"),
    IMAGE("image", "\u56fe\u7247"),
    VOICE("voice", "\u8bed\u97f3"),
    VIDEO("video", "\u89c6\u9891"),
    SHORT_VIDEO("shortvideo", "\u5c0f\u89c6\u9891"),
    LOCATION("location", "\u5730\u7406\u4f4d\u7f6e"),
    LINK("link", "\u94fe\u63a5"),
    EVENT("event", "\u4e8b\u4ef6");

    private String type;
    private String desc;
    private static final Map<String, WxMsgTypeEnum> ENUM_MAP;

    private WxMsgTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static WxMsgTypeEnum getByType(String type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public static boolean isEvent(String type) {
        WxMsgTypeEnum typeEnum = WxMsgTypeEnum.getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum == EVENT;
    }

    public static boolean isInteraction(String type) {
        WxMsgTypeEnum typeEnum = WxMsgTypeEnum.getByType(type);
        return typeEnum != null && !WxMsgTypeEnum.isEvent(type);
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        ENUM_MAP = new HashMap<String, WxMsgTypeEnum>();
        for (WxMsgTypeEnum typeEnum : WxMsgTypeEnum.values()) {
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }
}

