package cn.com.duiba.kjy.api.dto.marketing;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 营销礼物库
 * @author kjj mybatis generator
 * 2020-02-22
 */
@Data
public class SellerMarketingGiftDto implements Serializable {

    private static final long serialVersionUID = -3569954015597221870L;

    /**
     *主键id
     */
    private Long id;

    /**
     * 默认礼物库id
     */
    private Long marketingGiftId;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     *礼物名称
     */
    private String giftName;

    /**
     *礼物图片地址
     */
    private String giftPicUrl;

    /**
     * 礼物状态
     * @see cn.com.duiba.kjy.api.enums.DeletedEnum
     */
    private Integer deleted;

    /**
     * 来源
     * @see cn.com.duiba.kjy.api.enums.marketing.SellerMarketingGiftSourceEnum
     */
    private Integer giftSource;

}
