package cn.com.duiba.kjy.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.companyTrade.CompanyTradeDetailDto;
import cn.com.duiba.kjy.api.dto.companyTrade.CompanyTradeDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.PageQuery;

import java.util.List;

/**
 * 公司行业服务
 *
 * @author xiaotian
 * date 2019-04-17-16:41
 */
@AdvancedFeignClient
public interface RemoteCompanyTradeService {

    /**
     * 新增or更新
     *
     * @param companyTradeDto
     * @return
     */
    Boolean addOrUpdate(CompanyTradeDto companyTradeDto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    Boolean del(Long id) throws KjyCenterException;


    /**
     * 获取行业筛选下拉列表
     * @return
     */
    List<CompanyTradeDto>  getListForSearch();


    /**
     * 通过行业Id获取行业名称
     * @return
     */
    List<CompanyTradeDto>  getListByIds(List<Long> tradeIds);


    /**
     * 获取行业列表
     * @param pageQuery
     * @return
     */
    Page<CompanyTradeDetailDto>  getPage(PageQuery pageQuery);

}
