/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import java.net.URLDecoder;
import java.util.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdEncodeByBase64 {
    private static final Logger log = LoggerFactory.getLogger(IdEncodeByBase64.class);
    private static final Base64.Encoder encoder = Base64.getEncoder();
    private static final Base64.Decoder decoder = Base64.getDecoder();
    private static final String PREFIX = "Kj2";

    protected IdEncodeByBase64() {
    }

    protected static String encodingId(Long id) {
        id = id << 3 ^ 7L;
        String encode = encoder.encodeToString(Long.toString(id).getBytes());
        String replace = encode.replace("=", "");
        return PREFIX + (encode.length() - replace.length()) + replace;
    }

    public static Long decodingId(String encode) {
        if (StringUtils.isBlank((String)encode)) {
            return null;
        }
        try {
            if (!encode.startsWith("Kj")) {
                encode = new String(Hex.decodeHex((char[])encode.toCharArray()));
                encode = IdEncodeByBase64.decoder(encode);
            }
            StringBuilder substring = new StringBuilder(encode.substring(4));
            if (encode.startsWith("kj2")) {
                int equalNum = encode.charAt(3);
                for (int i = 0; i < equalNum; ++i) {
                    substring.append("=");
                }
            }
            String decode = new String(decoder.decode(substring.toString()));
            return Long.valueOf(decode) >> 3;
        }
        catch (Exception e) {
            log.info("encode ID error; id = {}", (Object)encode, (Object)e);
            return null;
        }
    }

    private static String decoder(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (Exception exception) {
            return url;
        }
    }

    public static void main(String[] args) {
        System.out.println(IdEncodeByBase64.encodingId(123L));
    }
}

