package cn.com.duiba.kjy.api.enums.seller;

/**
 * 代理人反馈枚举
 * @author 吴文哲
 * @date 2020-02-22 09:43
 **/
public enum SellerFeedbackEnum {

    VISITOR_NOT_WX_FRIEND_SIGN(1,"代理人访客非微信好友反馈");

    /**
     * 反馈类型
     */
    private Integer type;

    /**
     * 枚举
     */
    private String desc;

    SellerFeedbackEnum(Integer type,String desc){
        this.type = type;
        this.desc = desc;
    }


    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static SellerFeedbackEnum getByType(Integer type) {
        for (SellerFeedbackEnum enumVal : SellerFeedbackEnum.values()) {
            if (enumVal.getType().equals(type)) {
                return enumVal;
            }
        }
        return null;
    }

}
