package cn.com.duiba.kjy.api.params.content;

import cn.com.duiba.kjy.api.constant.ContentStatusEnum;
import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author linjianhui
 * @description  查询条件
 * @date 2020-02-08 01:03
 */
@Data
public class ContentEsParam  extends PageQuery {
    /**
     * 文章标题  es类型 text
     */
    private String title;

    /**
     * 内容id列表
     */
    private List<Long> contentIds;

    /**
     * 内容状态 es类型 integer
     */
    private ContentStatusEnum contentStatusEnum;

    /**
     * 多状态
     */
    private List<Integer> statusList;

    /**
     * 是否公有 es类型 integer
     */
    private Integer contentPublicly;

    /**
     * 公司id
     */
    private Long contentCompany;

    /**
     * 内容类型列表
     */
    private List<String> contentTypeList;

    /**
     * 一级标签id列表
     */
    private List<Long> firstTagIdList;

    /**
     * 二级标签id列表
     */
    private List<Long> secondTagIdList;

    /**
     * 是否按照分享数排序
     * true：按照分享数，不传/false：按照创建时间
     */
    private Boolean shareNum;

    /**
     * 用户 客集集的版本  1:通用版  2:保险专业版  非通用版可以看通用版的数据
     */
    private List<Integer> userVersion;
    /**
     * 是否推荐，0=不是、1=是
     */
    private Integer recommend;

    /**
     * 是否按照sort排序
     * true：按照sort，不传/false：按照创建时间
     */
    private Boolean sort;
    /**
     * 是否按照发布时间排序
     * true：按照发布时间，不传/false：按照创建时间
     */
    private Boolean releaseTime;
    /**
     * 最后创建时间，前台海报处用
     */
    private Date endDate;

    /**
     * 筛选发布时间（开始）
     */
    private Date startReleaseTime;

    /**
     * 筛选发布时间（结束）
     */
    private Date endReleaseTime;

}
