package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.CustDto;
import cn.com.duiba.kjy.api.dto.SellerCustomerDto;
import cn.com.duiba.kjy.api.dto.seller.SellerCustomerMarketingDto;
import cn.com.duiba.kjy.api.params.EditCustomerParam;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.SearchCustomerParam;
import cn.com.duiba.kjy.api.params.seller.SellerCustomerNicknameParams;
import cn.com.duiba.kjy.api.params.seller.SellerCustomerParam;
import cn.com.duiba.kjy.api.params.seller.SellerCustomerSearchParam;
import cn.com.duiba.kjy.api.params.seller.VisitListTypeEnum;

import java.util.List;
import java.util.Map;

/**
 * @author linjianhui
 * @description  销售客户信息服务
 * @date 2019-02-17 22:38
 */
@AdvancedFeignClient
public interface RemoteSellerCustomerService {

    /**
     * 根据销售员ID和用户ID查询
     * @param sellerId 销售员ID
     * @param userId 用户ID
     * @return
     */
    SellerCustomerDto findBySellerAndUser(Long sellerId, Long userId);

    /**
     * 根据销售员ID和用户ID查询
     * @param sellerId 销售员ID
     * @param nickname 微信用户昵称
     * @return
     */
    @Deprecated
    SellerCustomerDto findBySellerAndNickname(Long sellerId, String nickname);

    /**
     * 根据用户ID或用户昵称查询
     * @param sellerId 销售员ID
     * @param userId 客户用户ID
     * @param nickname 客户微信昵称
     * @return 客户信息
     */
    List<SellerCustomerDto> findByUserIdOrNickname(Long sellerId, Long userId, String nickname);


    /**
     * 通过主键id查询客户信息（销售员客户关联ID）
     * @param id
     * @return
     */
    SellerCustomerDto findById(Long id);

    /**
     * 通过销售id和用户id列表，查询客户列表
     * @param sellerId
     * @param sellerId
     * @return
     */
    List<SellerCustomerDto> findBySellerIdAndUserIds(Long sellerId,List<Long> userIds);

    /**
     * 根据参数查询客户列表
     * @param param
     * @return
     */
    Page<SellerCustomerDto> findSellerCustomer(SearchCustomerParam param);

    /**
     * 根据参数查询客户条数
     * @param param 参数
     * @return 条数
     */
    Integer countSellerCustomer(SearchCustomerParam param);

    /**
     * 编辑客户信息
     * @param param
     * @return
     */
    Integer updateSellerCustomer(EditCustomerParam param);

    /**
     * 加为客户
     * @param param
     * @return 返回客户ID
     */
    Long addSellerCustomer(EditCustomerParam param);

    /**
     * 添加中奖人
     * @param param
     * @return 返回客户ID
     */
    CustDto addWinner(EditCustomerParam param);


    /**
     * 删除中奖人
     * @param custIds
     * @return
     */
    Boolean delWinner(String custIds);

    /**
     * 更新客户最后访问时间
     * @param sellerId
     * @param userId
     * @return
     */
    Boolean updateLastVisitTime(Long sellerId, Long userId);

    Boolean updateVisitCountIncrease(Long sellerId, Long userId);

    /**
     *
     * @param idList
     * @return
     */
    List<SellerCustomerDto> findByIds(List<Long> idList);

    /**
     * 查询总数
     * @return
     */
    Integer getSellerCustomerCountByParam(SearchCustomerParam param);

    /**
     * 返回 用户id为主键的Map
     * @param sellerId
     * @param userIds
     * @return
     */
    Map<Long, SellerCustomerDto> getSellerCustomerMap(Long sellerId, List<Long> userIds);

    /**
     * 根据条件查询客户总数
     * @param param
     */
    Integer countByCondition(SellerCustomerParam param);

    /**
     * 根据条件查询客户列表
     * @param param
     * @return
     */
    List<SellerCustomerDto>  findByCondition(SellerCustomerParam param);

    /**
     * 更新客户行为
     * @param sellerId  代理人Id
     * @param userId   客户userid
     * @param custAction  客户行为
     * @return
     */
    int updateCustAction(Long sellerId, Long userId, VisitListTypeEnum custAction);

    /**
     * 获取代理人客户 Id->备注名Map
     * @param sellerId
     * @return
     */
    Map<Long,String> getCustomerId2RemarkNameMap(Long sellerId, List<Long> custUserIds);

    /**
     * 根据销售员ID和微信昵称分页查询
     * @param params 参数
     * @return 客户列表
     */
    List<SellerCustomerDto> findPageByNickName(SellerCustomerNicknameParams params);

    /**
     * 查询代理人客户列表
     * @param param
     * @return
     */
    List<SellerCustomerMarketingDto> searchEsCustomer(SellerCustomerSearchParam param);

    /**
     * 根据用户id 查询 所有客户信息列表
     * @param userId
     * @return
     */
    List<SellerCustomerDto> findByUserId(Long userId);
}
