package cn.com.duiba.kjy.api.dto.grabmaterial;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 爬虫管理账号列表
 *
 * @Author chentiecheng
 * @Date 2020/3/9 10:24 上午
 */
@Data
public class GrabAccountListDto implements Serializable {
    private static final long serialVersionUID = -3352475537914240864L;
    /**
     * id
     */
    private Long id;
    /**
     * 账号名称
     */
    private String webName;
    /**
     * 平台来源
     */
    private Integer webType;
    /**
     * 今日爬取
     */
    private Integer todayGrabNum;
    /**
     * 一级标签
     */
    private String firstSign;
    /**
     * 二级标签
     */
    private String secondSign;
    /**
     * 爬取状态
     */
    private Integer grabStatus;
    /**
     * 最近一次爬取
     */
    private Date lastGrabTime;
    /**
     * 爬取时间
     */
    private String grabTimes;
}
