package cn.com.duiba.kjy.api.remoteservice.invitationLetter;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.invitationLetter.InvitationLetterDetailDto;
import cn.com.duiba.kjy.api.dto.invitationLetter.InvitationLetterExtDto;
import cn.com.duiba.kjy.api.dto.invitationLetter.InvitationLetterListDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.content.SearchInvitationLetterParam;

import java.util.List;

/**
 * 邀请函ext rpc服务接口
 * @author 吴文哲
 * @date 2020-02-19 11:30
 **/
@AdvancedFeignClient
public interface RemoteInvitationLetterExtService {

    /**
     * 根据contentIds 获取邀请函拓展信息
     * @param contentIds
     * @return
     */
    List<InvitationLetterExtDto> getExtByContentIds(List<Long> contentIds);

    /**
     * 分页查询
     * @param params 分页参数
     * @return 邀请函列表及分页参数
     */
    Page<InvitationLetterListDto> findPage(SearchInvitationLetterParam params);

    /**
     * 根据邀请函ID查询
     * @param id 邀请函ID，对应tb_content.id
     * @return 邀请函详情
     */
    InvitationLetterDetailDto findById(Long id);

    /**
     * 新增或更新
     * @param dto 邀请函详情
     * @return 执行结果
     * @throws KjyCenterException 新增或更新失败的自定义异常
     */
    Long saveOrUpdate(InvitationLetterDetailDto dto) throws KjyCenterException;
}
