/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.dto;

import cn.com.duiba.kjy.api.constant.ContentTypeEnum;
import cn.com.duiba.kjy.api.dto.ContentDto;
import cn.com.duiba.kjy.api.dto.MarketAreaItemDto;
import cn.com.duiba.kjy.api.dto.SellerContentSimpleDto;
import cn.com.duiba.kjy.api.dto.SellerDto;
import cn.com.duiba.kjy.api.dto.UserDto;
import cn.com.duiba.kjy.api.dto.exclusive.ExclusiveAreaItemDto;
import java.util.Optional;

public class SellerContentDto
extends SellerContentSimpleDto {
    private static final long serialVersionUID = 5798315746562532180L;
    private UserDto userDto;
    private SellerDto sellerDto;
    private ContentDto contentDto;
    private ExclusiveAreaItemDto exclusiveAreaItemDto;
    private MarketAreaItemDto marketAreaItemDto;
    private Integer customContentType;

    public static String getTitle(SellerContentDto sellerContentDto) {
        if (ContentTypeEnum.isContent(sellerContentDto.getContentType())) {
            return Optional.ofNullable(sellerContentDto.getContentDto()).map(ContentDto::getTitle).orElse("");
        }
        if (ContentTypeEnum.isExclusive(sellerContentDto.getContentType())) {
            return Optional.ofNullable(sellerContentDto.getExclusiveAreaItemDto()).map(ExclusiveAreaItemDto::getTitle).orElse("");
        }
        if (ContentTypeEnum.isMarket(sellerContentDto.getContentType())) {
            return Optional.ofNullable(sellerContentDto.getMarketAreaItemDto()).map(MarketAreaItemDto::getTitle).orElse("");
        }
        return "";
    }

    public UserDto getUserDto() {
        return this.userDto;
    }

    public SellerDto getSellerDto() {
        return this.sellerDto;
    }

    public ContentDto getContentDto() {
        return this.contentDto;
    }

    public ExclusiveAreaItemDto getExclusiveAreaItemDto() {
        return this.exclusiveAreaItemDto;
    }

    public MarketAreaItemDto getMarketAreaItemDto() {
        return this.marketAreaItemDto;
    }

    public Integer getCustomContentType() {
        return this.customContentType;
    }

    public void setUserDto(UserDto userDto) {
        this.userDto = userDto;
    }

    public void setSellerDto(SellerDto sellerDto) {
        this.sellerDto = sellerDto;
    }

    public void setContentDto(ContentDto contentDto) {
        this.contentDto = contentDto;
    }

    public void setExclusiveAreaItemDto(ExclusiveAreaItemDto exclusiveAreaItemDto) {
        this.exclusiveAreaItemDto = exclusiveAreaItemDto;
    }

    public void setMarketAreaItemDto(MarketAreaItemDto marketAreaItemDto) {
        this.marketAreaItemDto = marketAreaItemDto;
    }

    public void setCustomContentType(Integer customContentType) {
        this.customContentType = customContentType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SellerContentDto)) {
            return false;
        }
        SellerContentDto other = (SellerContentDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UserDto this$userDto = this.getUserDto();
        UserDto other$userDto = other.getUserDto();
        if (this$userDto == null ? other$userDto != null : !this$userDto.equals(other$userDto)) {
            return false;
        }
        SellerDto this$sellerDto = this.getSellerDto();
        SellerDto other$sellerDto = other.getSellerDto();
        if (this$sellerDto == null ? other$sellerDto != null : !this$sellerDto.equals(other$sellerDto)) {
            return false;
        }
        ContentDto this$contentDto = this.getContentDto();
        ContentDto other$contentDto = other.getContentDto();
        if (this$contentDto == null ? other$contentDto != null : !this$contentDto.equals(other$contentDto)) {
            return false;
        }
        ExclusiveAreaItemDto this$exclusiveAreaItemDto = this.getExclusiveAreaItemDto();
        ExclusiveAreaItemDto other$exclusiveAreaItemDto = other.getExclusiveAreaItemDto();
        if (this$exclusiveAreaItemDto == null ? other$exclusiveAreaItemDto != null : !this$exclusiveAreaItemDto.equals(other$exclusiveAreaItemDto)) {
            return false;
        }
        MarketAreaItemDto this$marketAreaItemDto = this.getMarketAreaItemDto();
        MarketAreaItemDto other$marketAreaItemDto = other.getMarketAreaItemDto();
        if (this$marketAreaItemDto == null ? other$marketAreaItemDto != null : !this$marketAreaItemDto.equals(other$marketAreaItemDto)) {
            return false;
        }
        Integer this$customContentType = this.getCustomContentType();
        Integer other$customContentType = other.getCustomContentType();
        return !(this$customContentType == null ? other$customContentType != null : !((Object)this$customContentType).equals(other$customContentType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SellerContentDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UserDto $userDto = this.getUserDto();
        result = result * 59 + ($userDto == null ? 43 : $userDto.hashCode());
        SellerDto $sellerDto = this.getSellerDto();
        result = result * 59 + ($sellerDto == null ? 43 : $sellerDto.hashCode());
        ContentDto $contentDto = this.getContentDto();
        result = result * 59 + ($contentDto == null ? 43 : $contentDto.hashCode());
        ExclusiveAreaItemDto $exclusiveAreaItemDto = this.getExclusiveAreaItemDto();
        result = result * 59 + ($exclusiveAreaItemDto == null ? 43 : $exclusiveAreaItemDto.hashCode());
        MarketAreaItemDto $marketAreaItemDto = this.getMarketAreaItemDto();
        result = result * 59 + ($marketAreaItemDto == null ? 43 : $marketAreaItemDto.hashCode());
        Integer $customContentType = this.getCustomContentType();
        result = result * 59 + ($customContentType == null ? 43 : ((Object)$customContentType).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SellerContentDto(userDto=" + this.getUserDto() + ", sellerDto=" + this.getSellerDto() + ", contentDto=" + this.getContentDto() + ", exclusiveAreaItemDto=" + this.getExclusiveAreaItemDto() + ", marketAreaItemDto=" + this.getMarketAreaItemDto() + ", customContentType=" + this.getCustomContentType() + ")";
    }
}

