package cn.com.duiba.kjy.api.remoteservice.invitationLetter;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.invitationLetter.InvitationLetterConfDto;
import cn.com.duiba.kjy.api.params.invitationLetter.MyInvitationLetterParam;

import java.util.List;

/**
 * 邀请函配置 rpc 接口
 * @author 吴文哲
 * @date 2020-02-19 13:49
 **/
@AdvancedFeignClient
public interface RemoteInvitationLetterConfService {

    /**
     * 获取我的邀请函列表
     * @param param
     * @return
     */
    List<InvitationLetterConfDto> getMyInvitationLetters(MyInvitationLetterParam param);

    /**
     * 我的邀请函总数
     * @param param
     * @return
     */
    Integer countMyInvitationLetters(MyInvitationLetterParam param);

    /**
     * 新增代理人邀请函配置 返回主键
     * @param dto
     * @return
     */
    Long addInvitationLetterConfig(InvitationLetterConfDto dto);

    /**
     * 根据主键 更新代理人邀请函配置
     * @param dto
     * @return
     */
    Integer updateInvitationLetterConf(InvitationLetterConfDto dto);

    /**
     * 根据主键 获取邀请函配置详情
     * @param confId
     * @return
     */
    InvitationLetterConfDto getConfById(Long confId);
}
