package cn.com.duiba.kjy.api.remoteservice.sourcereload;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sourcereload.SourceReloadDto;

import java.util.List;

/**
 * @Author chentiecheng
 * @Date 2020/3/12 10:09 下午
 */
@AdvancedFeignClient
public interface RemoteSourceReloadService {
    /**
     * 批量更新，只更新次数
     * @param dtos
     * @return
     */
    Integer batchUpdate(List<SourceReloadDto> dtos);

    /**
     * 批量删除
     * @param ids
     * @return
     */
    Integer batchDelete( List<Long> ids);

    /**
     * 批量插入
     * @param dtos
     * @return
     */
    Integer batchInsert(List<SourceReloadDto> dtos);
}
