package cn.com.duiba.kjy.api.util;

/**
 * @author lizhi
 * @date 2019/10/23 3:11 PM
 */
public class BitUtils {

    /**
     * 针对一个10进制数的位运算，增加位
     *
     * @param number   10进制数
     * @param position 位数 从0开始
     * @return 增加位后的10进制数
     */
    public static long addBit(long number, int position) {
        if (number < 0 || position < 0) {
            return 0;
        }
        return number | moveLeft1(position);
    }

    /**
     * 判断 一个数number的二进制格式的第position位是否为1
     *
     * @param number   十进制数
     * @param position 第几位 右到左从0开始
     * @return true-是，false-否
     */
    public static boolean isTrue(long number, int position) {
        if (number < 0 || position < 0) {
            return false;
        }
        long decimalValue = moveLeft1(position);
        return (decimalValue & number) == decimalValue;
    }

    /**
     * 针对一个10进制数的位运算，删除位
     *
     * @param number   10进制数
     * @param position 位数 从0开始
     * @return 删除位后的10进制数
     */
    public static long removeBit(long number, int position) {
        if (number < 0 || position < 0) {
            return 0;
        }
        if (isTrue(number, position)) {
            number = number - moveLeft1(position);
        }
        return number;
    }


    private static long moveLeft1(int num) {
        return 1L << num;
    }
}
