package cn.com.duiba.kjy.api.remoteservice.push;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.content.GatherPageHotContentDto;
import cn.com.duiba.kjy.api.dto.content.HotContentDto;
import cn.com.duiba.kjy.api.enums.push.HotArticleSortOperateEnum;

import java.util.Date;
import java.util.List;

/**
 * @auther: linjianhui
 * @date: 2019-10-24 11:06
 * @description: 热文推荐
 */
@AdvancedFeignClient
public interface RemoteHotContentService {

    /**
     * 查询指定起始时间转发数
     * @param startDate
     * @param endDate
     * @return
     */
    Integer selectForwardNum(Date startDate,Date endDate);

    /**
     * 查询指定起始时间访客数
     * @param startDate
     * @param endDate
     * @return
     */
    Integer selectVisitNum(Date startDate,Date endDate);


    /**
     * 上移/下移热文
     * @param id
     * @param operate：1代表上移；2代表下移
     * @see HotArticleSortOperateEnum
     * @return
     */
    boolean move(Long id, int operate);

    /**
     * 试推热文
     * @param sellerId
     * @return
     */
    boolean contentPushEveryday(Long sellerId);

    /**
     * 添加热点内容
     * @param contentId
     * @return
     */
    boolean addHotContent(Long contentId);

    /**
     * 删除热点内容
     * @param contentId
     * @return
     */
    boolean delHotContent(Long contentId);

    /**
     * 更新热文ID
     * @param oldId
     * @param newId
     * @return
     */
    boolean updateHotArcticlesIds(Long oldId, Long newId);

    /**
     * 获取热文列表
     * @param dateDay
     * @return
     */
    List<HotContentDto> getHotContentList(Integer dateDay);

    /**
     * 集合页列表展示
     * @param dateDay 日期 e.g. 20200306
     * @param userVersion 用户版本
     * @return
     */
    List<GatherPageHotContentDto> getGatherPageHotContentDto(String dateDay, Integer userVersion);

    /**
     * 根据日期查询今日热文总数
     * @param contentVersion
     * @param dateDay
     * @return
     */
    int countByContentVersionAndDateDay(Integer contentVersion, String dateDay);

}
