package cn.com.duiba.kjy.api.dto.marketing;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 访客营销礼物领取记录
 * @author kjj mybatis generator
 * 2020-02-22
 */
@Data
public class VisitorMarketingGiftRecordDto implements Serializable {

    private static final long serialVersionUID = -4775449676564878599L;

    /**
     *主键id
     */
    private Long id;

    /**
     * 代理人营销礼物库配置id，对应tb_seller_marketing_gift_conf.id
     */
    private Long giftConfId;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * 代理人用户id
     */
    private Long sellerUserId;

    /**
     * 访客id
     */
    private Long visitorId;

    /**
     * 领取状态
     * @see cn.com.duiba.kjy.api.enums.marketing.VisitorMarketingGiftReceiveStateEnum
     */
    private Integer receiveState;

    /**
     * 礼物名称
     */
    private String giftName;

    /**
     * 礼物图片地址
     */
    private String giftPicUrl;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
