package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.ContentTypeEnum;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.ContentDto;
import cn.com.duiba.kjy.api.dto.ContentExtDto;
import cn.com.duiba.kjy.api.dto.ContentMatrixDto;
import cn.com.duiba.kjy.api.dto.ContentSimpleInfo;
import cn.com.duiba.kjy.api.dto.InteractionDto;
import cn.com.duiba.kjy.api.dto.TodayNewCountDto;
import cn.com.duiba.kjy.api.dto.content.ContentDefaultDataTagDto;
import cn.com.duiba.kjy.api.dto.content.ContentPlusDto;
import cn.com.duiba.kjy.api.dto.content.ContentTitleDto;
import cn.com.duiba.kjy.api.dto.content.ContentTitleMainImgUrlDto;
import cn.com.duiba.kjy.api.dto.content.DailyMsgDto;
import cn.com.duiba.kjy.api.dto.content.DailySimpleInfoDto;
import cn.com.duiba.kjy.api.dto.content.GatherPageDailyDto;
import cn.com.duiba.kjy.api.dto.content.GatherPageEveningDto;
import cn.com.duiba.kjy.api.dto.content.TitleAndTextDto;
import cn.com.duiba.kjy.api.dto.contentinteractionoption.ContentInteractionOptionDto;
import cn.com.duiba.kjy.api.dto.contentinteractionquestion.ContentInteractionQuestionDto;
import cn.com.duiba.kjy.api.dto.contentinteractionvote.ContentInteractionVoteDto;
import cn.com.duiba.kjy.api.enums.push.HotArticleSortOperateEnum;
import cn.com.duiba.kjy.api.params.ContentSearchParams;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.content.EsContentSearchParam;
import cn.com.duiba.kjy.api.params.content.SearchInvitationLetterParam;
import org.joda.time.LocalDate;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by zhangshun on 2019/2/13.
 */
@AdvancedFeignClient
public interface RemoteContentService {

    /**
     * 查询文章列表
     * @param contentSearchParams
     * @return
     */
    List<ContentDto> selectList(ContentSearchParams contentSearchParams);

    /**
     * 查询文章列表
     * @param contentSearchParams
     * @return
     */
    List<ContentPlusDto> selectPlusList(ContentSearchParams contentSearchParams);

    /**
     * 查询文章列表,首页3.1新接口
     * @param contentSearchParams
     * @return
     */
    Page<ContentPlusDto> selectNewPlusList(ContentSearchParams contentSearchParams);

    /**
     * 查询活动列表
     * @param contentSearchParams
     * @return
     */
    List<ContentDto> selectActivityList(ContentSearchParams contentSearchParams);

    /**
     * 查询活动列表，首页3.1新接口
     * @param contentSearchParams
     * @return
     */
    Page<ContentDto> selectNewActivityList(ContentSearchParams contentSearchParams);

    /**
     * 文章分享次数加1
     * @param contentId
     * @return
     */
    Boolean sharedNumIncrease(Long contentId,Long sellerId);

    /**
     * 查询总数
     * @param params
     * @return
     */
    Long selectCount(ContentSearchParams params);

    /**
     * 通过id列表批量查询内容
     * @param ids
     * @return
     */
    List<ContentDto> findByIds(List<Long> ids);

    /**
     * 通过id列表批量查询内容
     * @param ids
     * @return
     */
    List<ContentDto> findAllByIds(List<Long> ids);

    /**
     * 通过id列表批量查询内容
     * @param ids
     * @return
     */
    Map<Long, ContentDto> findAllMapByIds(List<Long> ids);

    /**
     * 根据内容id查询内容，包括扩展信息
     * @param id
     * @return
     */
    ContentExtDto findExtByContentId(Long id);

    /**
     *
     * @param ids
     * @return
     */
    Map<Long, ContentExtDto> findExtByIds(List<Long> ids);

    /**
     * 根据内容ID集合，获取内容推荐语
     * @param ids 内容ID集合
     * @return 推荐语
     */
    Map<Long, String> findRecommendDescByIds(List<Long> ids);

    /**
     *
     * @param ids
     * @return
     */
    Map<Long, ContentMatrixDto> findMatrixByIds(List<Long> ids);

    /**
     * 根据内容id查询内容，包括扩展信息
     * @param id
     * @return
     */
    ContentDto findByContentId(Long id);

    /**
     * 根据内容id查询内容，包括统计字段
     * @param id
     * @return
     */
    ContentPlusDto findPlusByContentId(Long id);

    /**
     * 新增内容 包含主体
     * @param contentExtDto
     * @return
     * @throws KjyCenterException
     */
    Long insert(ContentExtDto contentExtDto) throws KjyCenterException;

    /**
     * 跟新内容 包含主体
     * @param contentExtDto
     * @return
     */
    Integer update(ContentExtDto contentExtDto);

    /**
     * 更新内容
     * @param contentExtDto
     * @return
     */
    Boolean updateContent(ContentExtDto contentExtDto);

    /**
     * 跟新内容 包含主体
     *
     * @deprecated
     * @param status
     * @return
     */
    @Deprecated
    Boolean updateStatus(Long id, Integer status) throws KjyCenterException;

    /**
     * 批量删除 包含主体
     * @param ids
     * @return
     */
    Integer bathDelete(List<Long> ids);

    /**
     * 发布/撤回 内容
     * @param id
     * @param open
     * @return
     */
    Integer openContent(Long id, Integer open);

    /**
     * 跟新排序 上移，下移
     * @param id
     * @param sort ： >0 上移 < 0下移
     * @param contentType 内容类型
     * @return
     */
    Integer updateSort(Long id, Integer sort, ContentTypeEnum contentType);


    Integer updateContentTargetDestination(Long id, Integer destination, ContentTypeEnum contentType) throws KjyCenterException;


    /**
     * 跟新文章的敏感词检测结果
     * @param id
     * @param suggestion
     * @return
     */
    Integer updateArticleSuggestion(Long id,String suggestion);

    Integer update2TargetDestination(Long id, Integer destination, ContentSearchParams params) throws BizException;

    Boolean downloadNumIncrease(Long contentId);

    /**
     * 日报发布
     * @param id
     * @return
     */
    Boolean updateMatrixPriorityGrade(Long id, Integer grade);

    /**
     * 根据指定日期查询是否存在日报
     * @param releaseTime
     * @return
     */
    ContentDto findDailyByDate(Date releaseTime);

    /**
     * 根据指定日期和日报类型查询日报
     * @param releaseTime 日期
     * @param contentType 类型
     * @return 日报
     */
    ContentDto findDailyByDateAndType(Date releaseTime, String contentType);

    /**
     * 日报发布
     * @param id
     * @return
     */
    Boolean openDaily(Long id);

    /**
     * 获取发布中的日报
     * @return
     */
    ContentDto selectInitDaily();

    /**
     * 获取各种类型最近日期的发布中的日报（各种类型各一个）
     * @return 日报
     */
    List<ContentDto> selectInitDailyList();


    ContentDto nextCrawlerArticle(Long id);
    /**
     * 查询文章列表(管理后台专用)
     * @param contentSearchParams
     * @return
     */
    List<ContentDto> selectListForBackend(ContentSearchParams contentSearchParams);

    /**
     * 查询文章列表(管理后台专用)
     * @param contentSearchParams
     * @return
     */
    List<ContentPlusDto> selectPlusListForBackend(ContentSearchParams contentSearchParams);

    /**
     * 查询总数(管理后台专用)
     * @param params
     * @return
     */
    Long selectCountForBackend(ContentSearchParams params);

    /**
     * 获取简单信息
     * @param id
     * @param contentType
     * @return
     */
    ContentSimpleInfo findSimpleInfo(Long id, String contentType);

    TodayNewCountDto countTodayNewCountDto(Long tagId);

    /**
     * 获取今日日报简单信息列表
     * @return
     */
    List<DailySimpleInfoDto> findSimpleTodayDaily();


    /**
     * 获取某一天早报数
     * @param date
     * @return
     */
    int countDailyByDate(LocalDate date);

    /**
     * 获取某一天早报列表
     * @param date
     * @return
     */
    List<DailySimpleInfoDto> findSimpleDaily(LocalDate date);

    /**
     * 根据销售员ID和早报ID给单个销售员推送早报(管理后台专用)
     * @param sellerId 销售员ID
     * @param dailyId 早报ID
     * @return true-成功，false-失败
     */
    boolean sendDailyBySeller(Long sellerId, Long dailyId);

    /**
     * 根据销售员ID和晚报ID给单个销售员推送晚报(管理后台专用)
     * @param sellerId 销售员ID
     * @param eveningId 晚报ID
     * @return true-成功，false-失败
     */
    Boolean sendEveningBySeller(Long sellerId, Long eveningId);

    /**
     * 根据活动主键列表获取是否为中奖活动
     * @param contentIds
     * @return
     */
    Map<Long, Boolean> getActivityIsLotteryMap(List<Long> contentIds);

    /**
     * 跟新定时发布的时间
     * @param id
     * @param openTime
     * @return
     */
    Integer updateTiming(Long id, Date openTime);

    int updateTag(ContentDto record);

    /**
     * 添加内容互动（用于同步数据，投票不设置默认值）
     *
     * @param questionDto 内容互动问题
     * @param voteDtos    用户互动通用投票记录
     * @param optionDtos  内容互动选项
     * @return 是否添加成功
     */
    boolean addOrUpdateInteraction(ContentInteractionQuestionDto questionDto, List<ContentInteractionVoteDto> voteDtos, List<ContentInteractionOptionDto> optionDtos) throws KjyCenterException;

    /**
     * 添加内容互动（过度方案，重构后这里就删掉了）
     *
     * @param interactionTemplateId 互动模板ID
     * @param questionDto 内容互动问题
     * @param voteDtos    用户互动通用投票记录
     * @param optionDtos  内容互动选项
     * @return 是否添加成功
     */
    boolean addOrUpdateInteractionTemp(Long interactionTemplateId, ContentInteractionQuestionDto questionDto, List<ContentInteractionVoteDto> voteDtos, List<ContentInteractionOptionDto> optionDtos) throws KjyCenterException;

    /**
     * 根据文章id查看用户参与的活动详情
     *
     * @param contentId
     * @param userId
     * @return
     */
    InteractionDto getInteractiveByContentId(Long contentId, Long userId, Long scId);

    /**
     * 通用投票
     *
     * @param voteType   投票类型
     * @param questionId 问题id
     * @return 投票是否成功
     */
    boolean commonVote(Integer voteType, Long questionId);

    /**
     * 根据问题id找到对应选项
     *
     * @param questionId 问题id
     * @return 选项
     */
    List<ContentInteractionOptionDto> findOptionByQuestionId(Long questionId);

    /**
     * 根据问题查找投票
     *
     * @param questionId 问题id
     * @return 投票
     */
    List<ContentInteractionVoteDto> findVoteByQuestionId(Long questionId);

    /**
     * 多选项投票
     *
     * @param voteId 用户投票的id
     * @return 是否投票成功
     */
    boolean multiOptionVoting(List<Long> voteId) throws KjyCenterException;

    /**
     * 查看内容对应投票 管理端
     *
     * @param contentId 内容id
     * @return
     */
    InteractionDto participateSys(Long contentId);

    /**
     * 获取某一天早报列表(简单信息)
     * @param date
     * @return
     */
    List<DailyMsgDto> findSimpleDailyInfo(LocalDate date);

    /**
     * 根据主键id查询内容信息（5分钟缓存）
     * @param id
     * @return
     */
    ContentDto findByIdWithCache(Long id);

    /**
     * 获取热文推送列表
     * @param dayNumber 通过DateUtils.getDayNumber 获取
     * @return
     */
    @Deprecated
    List<ContentDto> getCacheHotContentList(Integer dayNumber);

    /**
     * 查询文章列表
     * @param contentIds
     * @return
     */
    List<ContentPlusDto> selectPlusListByIds(List<Long> contentIds);


    /**
     * 增加关注数
     * @param contentId
     * @return
     */
    Boolean attentionNumIncrease(Long contentId);

    /**
     * 根据主键查询标题和主图
     * @param ids 主键集合
     * @return 标题和主图集合
     */
    @Deprecated
    List<ContentTitleMainImgUrlDto> findTitleAndMainImgUrlByIds(List<Long> ids);

    /**
     * 根据主键查询标题和主图
     * @param ids 内容ids
     * @param checkValid 是否需要检查有效(sql层面)
     * @return
     */
    List<ContentTitleMainImgUrlDto> findValidTitleAndMainImgUrlByIds(List<Long> ids, boolean checkValid);

    /**
     * 根据文章ID列表查询文章标题
     * @param ids
     * @return
     */
    List<ContentTitleDto> selectIdAndTitleByIds(List<Long> ids);

    /**
     * 根据文章id列表，获取默认数据标签
     * @param ids
     * @return
     */
    List<ContentDefaultDataTagDto> selectDefaultDataTag(List<Long> ids);

    /**
     * es中查询列表
     * @param param
     * @return
     */
    List<Long> fingEsPageList(EsContentSearchParam param);

    /**
     * 查询邀请函列表
     * @param param
     * @return
     */
    List<ContentDto> getInvitationLetters(SearchInvitationLetterParam param);

    /**
     * 邀请函内容总数统计
     * @param param
     * @return
     */
    Integer countInvitationLetters(SearchInvitationLetterParam param);

    /**
     * 根据id查询文章的内容和标题
     * @param id
     * @return
     */
    TitleAndTextDto getTitleAndTextById(Long id);

    /**
     * 根据id查询文章的内容和标题
     * @param id
     * @param url
     * @return
     */
    Boolean updateTextUrlById(Long id,String url);

    /**
     * 更新发布时间
     * @param contentId
     * @param dailyReleaseTime
     */
    void updateDailyReleaseTime(Long contentId, Date dailyReleaseTime);

    /**
     * 日报集合页获取日报列表
     * @param startDate
     * @param endDate
     * @return
     */
    List<GatherPageDailyDto> getGatherPageDailyDto(Date startDate, Date endDate);

    /**
     * 晚报结合页获取晚报列表
     * @param startDate
     * @param endDate
     * @return
     */
    @Deprecated
    List<GatherPageEveningDto> getGatherPageEveningDto(Date startDate, Date endDate);


    /**
     * 晚报结合页获取晚报列表
     * @param startDate
     * @param endDate
     * @param isFromMore 是否来自查看更多
     * @return
     */
    List<GatherPageEveningDto> getGatherPageEveningDtoV2(Date startDate, Date endDate, boolean isFromMore);

    /**
     * 根据时间查询当日晚安心语数量
     * @param dateDay
     * @return
     */
    int countEveningNumByDate(String dateDay);
	
	/**
     * 获取内容的版本
     * @param id
     * @return
     */
    Integer getContentVersion(Long id);

    /**
     * 过滤contentIds状态不为开启的内容
     * @param contentIds
     * @return
     */
    List<Long> listAvailableContentIds(List<Long> contentIds);
}
