package cn.com.duiba.kjy.api.remoteservice.lottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.params.lottery.LotteryTimesParams;

/**
 * @author lizhi
 * @date 2019/10/23 3:50 PM
 */
@AdvancedFeignClient
public interface RemoteDrawPrizeTimesService {

    /**
     * 查询剩余次数
     * @param lotteryTimesParams 相关参数
     * @return 剩余次数，-1代表参数错误
     */
    int getRemainingTimes(LotteryTimesParams lotteryTimesParams);

    /**
     * 增加参与次数
     * @param lotteryTimesParams 相关参数
     * @return 是否更新成功
     */
    boolean increaseRecordTimes(LotteryTimesParams lotteryTimesParams);

    /**
     * 增加分享次数
     * @param lotteryTimesParams 相关参数
     * @return 是否成功
     */
    boolean increaseShareTimes(LotteryTimesParams lotteryTimesParams);
}
