package cn.com.duiba.kjy.api.util;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/**
 * @author 吴文哲
 * @date 2019-12-16 10:53
 **/
public class GZipUtil {


    public static String compress(String str) throws IOException {
        if (StringUtils.isBlank(str)) {
            return str;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(str.getBytes());
        gzip.close();
        String outStr = new String(Base64.encodeBase64(out.toByteArray()));
        return outStr;
    }

    public static String uncompress(String str) throws IOException {
        if (StringUtils.isBlank(str)) {
            return str;
        }
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(Base64.decodeBase64(str)));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy(gis, out);
        return new String(out.toByteArray());
    }

    public static void main(String[] args) throws Exception {

        StringBuilder sb = new StringBuilder();
        sb.append("//yun.duiba.com.cn/kjy/image/20191214/01d815652e99440aa8e1d7eefb7c5fd3.jpg,//yun.duiba.com.cn/kjy/image/20191214/d30f23c2077943cdb60eff00c44861cd.jpg,//yun.duiba.com.cn/kjy/image/20191214/1564f08dc232444e883b2a238e4aaea6.jpg,//yun.duiba.com.cn/kjy/image/20191216/cdc2741387f742b8b62541736c7a8f34.jpg,//yun.duiba.com.cn/kjy/image/20191216/d9f10429db1d424494ae61e45d32bde7.jpg,//yun.duiba.com.cn/kjy/image/20191216/8df950cf7bb34826955d8677ca680d95.jpg,//yun.duiba.com.cn/kjy/image/20191216/c7d05105d83244b9917bffbdf9f5de40.jpg,//yun.duiba.com.cn/kjy/image/20191216/15db9192fb0246efbba9563b85a6704f.jpg,//yun.duiba.com.cn/kjy/image/20191216/c72369dbe029475eaaf12ec0f79bdf01.jpg");
        String str = sb.toString();
        String str1 = GZipUtil.compress(sb.toString());
        String result = GZipUtil.uncompress(str1);
        System.out.println("原长度：" + str.length());
        System.out.println("压缩后字符串：" + str1);
        String[] arr = str1.split(",");
        for(int i=0;i<arr.length;i++){
            System.out.println(i+" arr:"+arr.toString());
        }
        System.out.println("压缩后字符串长度：" + str1.length());
        System.out.println(result.equals(str));
        System.out.println("解压缩后字符串：" + result);
    }

}
