package cn.com.duiba.kjy.api.enums.lottery;

import cn.com.duiba.wolf.utils.DateUtils;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/10/23 3:07 PM
 */
public enum LotteryTimesTypeEnum {

    FOREVER(0, "永久"),
    DAILY(1, "每日"),
    ;

    private Integer type;
    private String desc;

    LotteryTimesTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, LotteryTimesTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(LotteryTimesTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }

    public static LotteryTimesTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public static String getDateByType(Integer type) {
        LotteryTimesTypeEnum timesTypeEnum = getByType(type);
        if (timesTypeEnum == null) {
            return "";
        }
        if (DAILY.equals(timesTypeEnum)) {
            return DateUtils.getDayStr(new Date());
        } else if (FOREVER.equals(timesTypeEnum)) {
            return "";
        } else {
            return "";
        }
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
