package cn.com.duiba.kjy.api.enums.pay;

import java.util.HashMap;
import java.util.Map;

/**
 * 企业付款，查询订单返回的订单状态
 * @author lizhi
 * @date 2020/1/8 2:12 PM
 */
public enum WxCompanyPayStatusEnum {

    SUCCESS("SUCCESS", "转账成功"),
    FAILED("FAILED", "转账失败"),
    PROCESSING("PROCESSING","处理中"),
    ;
    private String code;
    private String desc;

    WxCompanyPayStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    private static final Map<String, WxCompanyPayStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(WxCompanyPayStatusEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static WxCompanyPayStatusEnum getByCode(String code) {
        return ENUM_MAP.get(code);
    }

}
