package cn.com.duiba.kjy.api.params.Activationcode;

import cn.com.duiba.kjy.api.constant.ActivationCodeTypeEnum;
import cn.com.duiba.kjy.api.enums.BatchCodeRuleEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhanghuifeng
 * date 2019-04-17-16:56
 */
@Data
public class ActivationCodeAddDto implements Serializable {
    private static final long serialVersionUID = 4174071048233245300L;

    /**
     * 激活码
     */
    private List<String> codeList;

    /**
     * 批次号
     */
    private String batch;

    /**
     * 类型
     */
    private ActivationCodeTypeEnum codeTypeEnum;

    /**
     * 有效期
     */
    private Integer validity;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 批次激活码组成规则
     * @see BatchCodeRuleEnum
     */
    private String batchCodeRule;

    /**
     * 用户版本信息
     * @see cn.com.duiba.kjy.api.enums.version.UserVersionEnum
     */
    private Integer userVersion;

    /**
     * 代理人销售id
     */
    private Long agentSellerId;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

}
