package cn.com.duiba.kjy.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/3/3 5:33 PM
 */
public enum PayChannelEnum {

    DUI_BA(0, "兑吧"),
    KJY_PAY_CENTER(1, "客集集支付系统"),

    ;

    private Integer code;

    private String desc;

    PayChannelEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, PayChannelEnum> ENUM_MAP = new HashMap<>();

    static{
        for(PayChannelEnum channelEnum : values()){
            ENUM_MAP.put(channelEnum.getCode(), channelEnum);
        }
    }

    public static PayChannelEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
