package cn.com.duiba.kjy.api.params.seller;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 销售团队数据查询条件
 * @author zhanghuifeng
 * date 2020/3/25-3:18 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SellerTeamDateInfoParam extends PageQuery {
    private static final long serialVersionUID = -155117749719463045L;

    /**
     * 上级ID
     */
    private Long superiorId;

    /**
     * 查询的数据类型
     * @see cn.com.duiba.kjy.api.enums.seller.SellerTeamDateTypeEnum
     */
    private Integer dataType;

    /**
     * 记录类型
     * @see cn.com.duiba.kjy.api.enums.seller.SellerTeamStatRecordTypeEnum
     */
    private Integer recordType;

    /**
     * 代理人id
     */
    private List<Long> sellerIds;

    /**
     * 记录开始时间
     */
    private Date startTime;

    /**
     * 记录结束时间
     */
    private Date endTime;
}
