package cn.com.duiba.kjy.api.dto.seller;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 代理人客户意向度分析统计表
 *
 * @author 吴文哲
 * @date 2019-09-26 18:54
 **/
@Data
public class SellerCustomerStatisticsDto implements Serializable {

    private static final long serialVersionUID = 7868423072470693013L;
    /**
     * 主键
     */
    private Long id;
    /**
     * 客户UserId
     */
    private Long userId;
    /**
     * 代理人Id
     */
    private Long sellerId;
    /**
     * 客户意向度星级
     */
    private Integer star;
    /**
     * 客户意向度得分
     */
    private Long score;

    /**
     * 统计截止时间
     */
    private String statisticTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;
}
