package cn.com.duiba.kjy.api.util;

import lombok.extern.slf4j.Slf4j;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2020/3/11 13:52
 * @Description:
 */
@Slf4j
public class DateUtil {
    /**
     * 获取 当前年、半年、季度、月、日、小时 开始结束时间
     */
    public static final SimpleDateFormat longHourSdf = new SimpleDateFormat("yyyy-MM-dd HH");;

    /**
     * 指定日期为2020-04-04
     */
    private static final LocalDate FOUR_FOUR_OF_2020 = LocalDate.of(2020, 04, 04);

    public static Date getCurrentHourStartTime(Date now) {
        if(Objects.isNull(now)){
            now = new Date();
        }
        try {
            now = longHourSdf.parse(longHourSdf.format(now));
        } catch (Exception e) {
            log.warn("获取时间有误",e);
        }
        return now;
    }

    /**
     * 判断date 是否在 start 和 end之间 ( )
     *
     * @param date 被比较的时间
     * @param start 开始时间
     * @param end 结束时间
     * @return
     */
    public static boolean isDateBetween(Date date, Date start, Date end) {
        if (Objects.isNull(date) || Objects.isNull(start) || Objects.isNull(end)) {
            return false;
        }
        if (date.getTime() > end.getTime() || date.getTime() < start.getTime()) {
            return false;
        }
        return true;
    }

    /**
     * 判断 date是否在time之前 不包含边界
     *
     * @param date
     * @param time
     * @return
     */
    public static boolean isDateBefore(Date date, Date time) {
        if (Objects.isNull(date) || Objects.isNull(time)) {
            return false;
        }
        if (date.getTime() < time.getTime()) {
            return true;
        }
        return false;
    }
    /**
     * 判断 date是否在time之后 不包含边界
     *
     * @param date
     * @param time
     * @return
     */
    public static boolean isDateAfter(Date date, Date time) {
        if (Objects.isNull(date) || Objects.isNull(time)) {
            return false;
        }
        if (date.getTime() > time.getTime()) {
            return true;
        }
        return false;
    }

    /**
     * 根据LocalDateTime获取date
     * @param localDateTime
     * @return
     */
    public static Date covertToDate(LocalDateTime localDateTime){
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }

    /**
     * 是否是2020-04-04
     * @return
     */
    public static boolean isFourFourOf2020(){
        //获取当天的日期
        LocalDate now = LocalDate.now();
        return FOUR_FOUR_OF_2020.equals(now);
    }

}
