package cn.com.duiba.kjy.api.dto.interaction;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2019/9/19 3:08 PM
 */
@Data
public class ContentInteractionDto implements Serializable {

    private static final long serialVersionUID = 9050988944253212368L;

    /**
     *
     *主键
     */
    private Long id;

    /**
     * 内容id
     */
    private Long contentId;

    /**
     * 销售员转载ID
     */
    private Long scId;

    /**
     * 互动类型 0问答题单选 1问答题多选 2投票单选 3投票多选
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionTypeEnum
     */
    private Byte interactionType;

    /**
     * 标题
     */
    private String title;

    /**
     * 答案说明
     */
    private String instructions;

    /**
     * 一级标题
     */
    private String oneTitle;

    /**
     * 互动来源- 0-文章内配置的互动，1-互动题库，2-销售员模板，3-销售员配置
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionSourceEnum
     */
    private Integer interactionSource;

    /**
     * 是否启用配置
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionEnableConfigEnum
     */
    private Byte enableConfig;

}
