package cn.com.duiba.kjy.api.enums.redpacket;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/1/7 8:07 PM
 */
public enum RedPacketBizTypeEnum {

    GREETING_CARD(1, "节日贺卡"),
    ;

    private Integer code;
    private String desc;

    RedPacketBizTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, RedPacketBizTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(RedPacketBizTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static RedPacketBizTypeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
