/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    public static final SimpleDateFormat longHourSdf = new SimpleDateFormat("yyyy-MM-dd HH");

    public static Date getCurrentHourStartTime(Date now) {
        if (Objects.isNull(now)) {
            now = new Date();
        }
        try {
            now = longHourSdf.parse(longHourSdf.format(now));
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u65f6\u95f4\u6709\u8bef", (Throwable)e);
        }
        return now;
    }

    public static boolean isDateBetween(Date date, Date start, Date end) {
        if (Objects.isNull(date) || Objects.isNull(start) || Objects.isNull(end)) {
            return false;
        }
        return date.getTime() <= end.getTime() && date.getTime() >= start.getTime();
    }

    public static boolean isDateBefore(Date date, Date time) {
        if (Objects.isNull(date) || Objects.isNull(time)) {
            return false;
        }
        return date.getTime() < time.getTime();
    }

    public static boolean isDateAfter(Date date, Date time) {
        if (Objects.isNull(date) || Objects.isNull(time)) {
            return false;
        }
        return date.getTime() > time.getTime();
    }

    public static Date covertToDate(LocalDateTime localDateTime) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }

    public static Date yearAddOrSub(Date date, int offset) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.get(2);
        cal.set(2, cal.get(2) + offset);
        return cal.getTime();
    }
}

