package cn.com.duiba.kjy.api.enums.seller;

/**
 * 代理人统计数据记录类型枚举
 * @author zhanghuifeng
 * date 2020/3/24-4:43 下午
 */
public enum SellerTeamStatRecordTypeEnum {

    YESTERDAY(1, "昨天"),
    NEARLY_SEVEN_DAYS(2, "近七日"),
    ACCUMULATION(3, "累计"),
    ;

    private Integer code;

    private String desc;

    SellerTeamStatRecordTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static SellerTeamStatRecordTypeEnum getByCode(Integer code) {
        for (SellerTeamStatRecordTypeEnum enumVal : SellerTeamStatRecordTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (SellerTeamStatRecordTypeEnum enumVal : SellerTeamStatRecordTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
