package cn.com.duiba.kjy.api.remoteservice.sourcereload;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sourcereload.SourceReloadDto;

import java.util.List;

/**
 * 爬虫资源下载重试
 * @Author chentiecheng
 * @Date 2020/3/12 10:09 下午
 */
@AdvancedFeignClient
public interface RemoteSourceReloadService {
    /**
     * 批量更新，只更新次数
     * @param ids
     * @return
     */
    Integer batchUpdate(List<Long> ids);

    /**
     * 批量删除
     * @param ids
     * @return
     */
    Integer batchDelete( List<Long> ids);

    /**
     * 批量插入
     * @param dtos
     * @return
     */
    Integer batchInsert(List<SourceReloadDto> dtos);

    /**
     * 新增记录
     * @param dto
     * @return
     */
    Integer insert(SourceReloadDto dto);
}
