package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.dto.singlefestival.FestivalAwardConfigDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.math3.random.RandomDataGenerator;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 抽奖工具
 *
 * @author 吴文哲
 * @date 2019-10-28 09:55
 **/
@Slf4j
public class LotteryUtil {


    private static final int START = 1;
    // 奖品数量不受限制
    private static final int COUNT_UNLIMIT = -1;

    /**
     * 抽奖
     *
     * @param awardConfigDtoList id对应的中奖概率
     * @param lotteryRange       中奖范围
     * @return 中奖的id 如果范围null表示都没有中奖
     */
    public static FestivalAwardConfigDto getLottery(List<FestivalAwardConfigDto> awardConfigDtoList, Integer lotteryRange) {
        //随机生成一个 1 - lotteryRange的随机数
        int randomNum = getRandomForIntegerBounded(START, lotteryRange);
        int index = 1;
        FestivalAwardConfigDto awardDto = null;
        Map<Long,FestivalAwardConfigDto> id2LotteryMap = awardConfigDtoList.stream().collect(Collectors.toMap(FestivalAwardConfigDto::getId,
                Function.identity()));
        for (FestivalAwardConfigDto awardConfig : awardConfigDtoList) {
            //中奖概率 0.XXXXXX
            BigDecimal bd = awardConfig.getProbability();
            bd = bd.multiply(BigDecimal.valueOf(lotteryRange));
            index += bd.intValue();
            //随机数在当前中奖范围 [ )  包含起始  不包含结尾
            if (randomNum < index) {
                awardConfig.setRandom(randomNum);
                awardDto =  awardConfig;
                break;
            }
        }
        if(Objects.nonNull(awardDto)){
            //中奖ID
            Long awardId = awardDto.getId();
            //数据库中的中奖配置
            FestivalAwardConfigDto awardConfig = id2LotteryMap.get(awardId);
            if(Objects.nonNull(awardConfig)){
                //奖品发放数量是否超限
                if (!Objects.equals(awardConfig.getAwardCount(), COUNT_UNLIMIT) && awardConfig.getSendedCount() >= awardConfig.getAwardCount()) {
                    log.info("随机数:{},奖品没了:{}", randomNum, awardConfig.getAwardName());
                    return null;
                }
                return awardDto;
            }
        }
        //超出了数量限制 就返回null
        return null;
    }


    public static int getRandomForIntegerBounded(int min, int max) {
        return new RandomDataGenerator().nextInt(min, max);
    }


}
