package cn.com.duiba.kjy.api.params.fission;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @author : liuchao1@duiba.com.cn
 * @version V1.0
 * @date 2019年11月04日 10:19
 **/
@Data
@ToString
public class FissionPartakeRecordQueryParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 896940812967178221L;
    /**
     * 参与记录id
     */
    private Long id;

    /**
     * 参与记录id
     */
    private List<Long> ids;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 参与的用户id
     */
    private Long userId;

    /**
     * 上一级用户id
     */
    private Long sourceUserId;

    /**
     * 上级用户不是这个用户id
     */
    private Long notSourceUserId;

    /**
     * 用户id集合
     */
    private List<Long> userIds;

    /**
     * 是否已完成
     * true：需要时完成状态 false：不校验是否已完成
     */
    private Boolean hasFinish = false;

    /**
     * 是否已转发
     * true：需要转发数大于0的 false：不校验是否转发
     */
    private Boolean hasForward = false;
}
