package cn.com.duiba.kjy.api.dto.sellercardv5;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 吴文哲
 * @date 2020-03-16 16:07
 **/
@Data
public class SellerCardDtoV5 implements Serializable {
    private static final long serialVersionUID = -1942162908209281121L;

    /**
     *
     *主键
     */

    private Long id;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     *
     *头像区域风格 1:默认 2:专业大屏照
     */
    private Byte avatarStyle;

    /**
     *
     * 模板
     */
    private Byte backgroundStyle;

    /**
     * 专业认证
     */
    private String authentication;

    /**
     *
     *擅长专业
     */
    private String goodAtMajor;

    /**
     * 个人荣誉
     */
    private String honor;

    /**
     * 成功案例
     */
    private String cases;

    /**
     * 个人相册
     */
    private String splendidImage;

    /**
     *
     *创建时间
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     */
    private Date gmtModified;

    /**
     * 封面图片地址
     */
    @Deprecated
    private String cover;

    /**
     * 毕业院校
     */
    private String school;

    /**
     * 兴趣爱好 以|分隔
     */
    private String hobby;

    /**
     *
     *名片背景图
     */
    private String backgroundAvatar;

    /**
     * 名片地址
     */
    private String address;

    /**
     * 地址定位信息 用于前端反序列化
     */
    private String addressLocation;


}
