package cn.com.duiba.kjy.api.enums.user;

import java.util.HashMap;
import java.util.Map;

/**
 * 微信消息类型
 * @author lizhi
 * @date 2019/12/3 4:48 PM
 */
public enum WxMsgTypeEnum {

    TEXT("text", "文本"),
    IMAGE("image", "图片"),
    VOICE("voice", "语音"),
    VIDEO("video", "视频"),
    SHORT_VIDEO("shortvideo", "小视频"),
    LOCATION("location", "地理位置"),
    LINK("link", "链接"),
    EVENT("event", "事件"),
    ;

    private String type;

    private String desc;

    WxMsgTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<String, WxMsgTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(WxMsgTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }

    public static WxMsgTypeEnum getByType(String type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    /**
     * 是否是事件
     * @param type 类型
     * @return true-是，false-否
     */
    public static boolean isEvent(String type) {
        WxMsgTypeEnum typeEnum = getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum == EVENT;
    }

    /**
     * 是否是有效交互
     * @param type 类型
     * @return true-是，false-否
     */
    public static boolean isInteraction(String type) {
        WxMsgTypeEnum typeEnum = getByType(type);
        return typeEnum != null && !isEvent(type);
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
