package cn.com.duiba.kjy.api.remoteservice.sellercard;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sellercard.SellerCardAppraiseDto;
import cn.com.duiba.kjy.api.params.sellercard.SellerCardAppraiseQueryParam;

import java.util.List;

/**
 * 客户评价 rpc服务接口
 * @author 吴文哲
 * @date 2020-03-17 17:39
 **/
@AdvancedFeignClient
public interface RemoteSellerCardAppraiseService {

    /**
     * 根据主键查询
     * @param id
     * @return
     */
    SellerCardAppraiseDto findById(Long id);

    /**
     * 根据sellerId 和 visitorId 查询
     * @param sellerId
     * @param visitorId
     * @return
     */
    SellerCardAppraiseDto findBySellerIdAndVisitorId(Long sellerId,Long visitorId);


    /**
     * 根据条件分页查询
     * @param param
     * @return
     */
    List<SellerCardAppraiseDto> findByCondition(SellerCardAppraiseQueryParam param);


    /**
     * 根据条件统计
     * @param param
     * @return
     */
    Integer countByCondition(SellerCardAppraiseQueryParam param);


    /**
     * 根据主键更新评价状态
     * @param id
     * @param state
     * @return
     */
    Integer updateAppraiseState(Long id,Integer state);

    /**
     * 根据主键删除
     * @param id
     * @return
     */
    Integer delById(Long id);


    /**
     * 新增/修改客户评价
     * @param dto
     * @return  返回主键
     */
    Long saveAppraise(SellerCardAppraiseDto dto);




}
