package cn.com.duiba.kjy.api.remoteservice.serialPay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.orderRefund.OrderRefundDto;
import cn.com.duiba.kjy.api.dto.serialPayRecord.SerialPayRecordDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.PageQuery;
import cn.com.duiba.kjy.api.params.orderRefund.CheckParam;
import cn.com.duiba.kjy.api.params.orderRefund.OrderPageQuery;
import cn.com.duiba.kjy.api.params.preInstall.SerialPayPageQuery;

import java.util.List;

/**
 * 功能描述：销售申请退款接口
 *
 * @Auther: xiaotian
 * @Date: 2020/1/3 13:50
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteOrderRefundService {

    /**
     * 插入退款记录
     * @param orderRefundDto
     * @return
     */
    boolean insert(OrderRefundDto orderRefundDto) throws KjyCenterException;

    /**
     * 更新
     * @param orderRefundDto
     * @return
     */
    boolean update(OrderRefundDto orderRefundDto);

    /**
     * 财务审核
     * @param checkParam
     * @return
     */
    boolean check(CheckParam checkParam);

    /**
     * 筛选列表
     * @param pageQuery
     * @return
     */
    Page<OrderRefundDto> qureyList(OrderPageQuery pageQuery);

    /**
     * 根据付款订单id获取退款记录
     * @param orderId
     * @return
     */
    List<OrderRefundDto>  queryByPayOrderId(Long orderId);


    /**
     * 通过ID获取详情
     */
    OrderRefundDto  queryById(Long id);

}
