package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.CustDto;
import cn.com.duiba.kjy.api.dto.SellerCustomerDto;
import cn.com.duiba.kjy.api.dto.seller.CustomerStatisticsDto;
import cn.com.duiba.kjy.api.dto.seller.SellerCustomerMarketingDto;
import cn.com.duiba.kjy.api.dto.sellerCustomerInfoExt.SellerCustomerInfoExtDto;
import cn.com.duiba.kjy.api.params.EditCustomerParam;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.SearchCustomerParam;
import cn.com.duiba.kjy.api.params.seller.SellerCustomerNicknameParams;
import cn.com.duiba.kjy.api.params.seller.SellerCustomerParam;
import cn.com.duiba.kjy.api.params.seller.SellerCustomerSearchParam;
import cn.com.duiba.kjy.api.params.seller.VisitListTypeEnum;

import java.util.List;
import java.util.Map;

/**
 * @author chentiecheng
 * @description  销售客户信息拓展服务
 * @date 2019-02-17 22:38
 */
@AdvancedFeignClient
public interface RemoteSellerCustomerInfoExtService {

    /**
     * 根据销售客户表id查询客户信息
     * @param customerId
     * @return
     */
    SellerCustomerInfoExtDto selectInfoByCustomerId(Long customerId);

    /**
     * 根据销售客户表id列表 查询客户信息
     * @param customerIds 销售客户表id列表
     * @return
     */
    List<SellerCustomerInfoExtDto> selectInfoListByCustomerIds(List<Long> customerIds);
}
