package cn.com.duiba.kjy.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.company.CompanyDocumentDto;
import cn.com.duiba.kjy.api.params.company.CompanyDocumentParams;

import java.util.List;

/**
 * 公司资料
 * @author lizhi
 * @date 2019/6/29 3:28 PM
 */
@AdvancedFeignClient
public interface RemoteCompanyDocumentService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 资料
     */
    CompanyDocumentDto findById(Long id);

    /**
     * 新增或更新
     * @param companyDocumentDto 公司资料参数
     * @return 主键
     */
    Long insertOrUpdate(CompanyDocumentDto companyDocumentDto);

    /**
     * 分页查询列表
     * @param params 查询参数
     * @return 列表
     */
    List<CompanyDocumentDto> findPageList(CompanyDocumentParams params);

    /**
     * 查询总条数
     * @param params 参数
     * @return 总条数
     */
    long findCount(CompanyDocumentParams params);

    /**
     * 根据主键逻辑删除
     * @param id 主键
     * @return 删除条数
     */
    int delete(Long id);

    /**
     * 添加/修改文章
     *
     * @param dto 参数
     * @return 是否成功
     */
    int addOrUpdateForArticle(CompanyDocumentDto dto) throws KjyCenterException;

    /**
     * 资料库交换位置
     *
     * @param id        执行id
     * @param anotherId 另一个id
     * @return 是否成功
     */
    boolean exchangeLocation(Long id, Long anotherId);
}
