package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.params.seller.VisitListTypeEnum;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

/**
 * 客户行为转换器
 * 用于解析和存储 tb_seller_customer.cust_action 字段
 * 数据库中为int类型,使用时需要转回二进制字符串使用.
 * _ _ _ _ _ 一共5位(取值范围0-31) -1为初始值 目前只用了5位 从左到右分别表示  1:投票 2.答题 ;3.是否转发;4.中奖;5.资料
 * 相应位置上的数字如果是0 表示否  如果是1 表示是
 * 例如 00101 表示该用户 转发且填写资料   在数据库中存储为 5
 * 注意!!!!!! 如果要拓展该属性  需要在二进制数高位追加!!!!   即在左侧追加  并把LENGTH的值增加
 *
 * @author 吴文哲
 * @date 2019-09-02 16:43
 **/
public class CusActionConvertorUtil {

    /**
     * 总长度
     */
    public static final int LENGTH = 5;


    /**
     * 将 十进制 转为 二进制 字符串
     *
     * @param dbVal
     * @return
     */
    public static String getBinaryString(Integer dbVal) {
        return decimal2Binary(dbVal, LENGTH);
    }

    /**
     * 将二进制转为十进制
     *
     * @param binaryString
     * @return
     */
    public static Integer getOctalInteger(String binaryString) {
        return Integer.valueOf(binaryString, 2);
    }



    public static Integer getNewActionTypeInteger(Integer actionType, String binaryStr) {
        String pre = binaryStr.substring(0, LENGTH - actionType);
        String suf = binaryStr.substring(LENGTH - actionType + 1, LENGTH);
        return getOctalInteger(pre + "1" + suf);
    }



    /**
     * 所有可能的结果集合
     *
     * @param start
     * @param end
     * @return
     */
    public static List<Integer> getAllResult(int start, int end) {
        List<Integer> resultList = new LinkedList<>();
        int total = 2 << (LENGTH - 1);
        for (int i = 0; i < total; i++) {
            String binaryStr = decimal2Binary(i, LENGTH);
            //填写资料的所有可能
            if (Objects.equals(binaryStr.substring(start, end),"1")) {
                resultList.add(Integer.valueOf(binaryStr, 2));
            }
        }
        return resultList;
    }


    /**
     * 根据
     *
     * @param actionType 动作类行（1：资料，2：中奖，3：转发，4：答题，5：投票）
     * @return
     */
    public static List<Integer> getActionTypeIntList(Integer actionType) {
        if (Objects.isNull(actionType)) {
            return null;
        }
        VisitListTypeEnum typeEnum = VisitListTypeEnum.getByCode(actionType);
        List<Integer> resultList = null;
        int start = LENGTH - actionType;
        int end = start + 1;
        switch (typeEnum) {
            case MATERIAL:
                //填写资料
                resultList = getAllResult(start, end);
                break;
            case LOTTERY:
                //中奖
                resultList = getAllResult(start, end);
                break;
            case FORWARD:
                //转发
                resultList = getAllResult(start, end);
                break;
            case QUESTION:
                //答题
                resultList = getAllResult(start, end);
                break;
            case VOTE:
                //投票
                resultList = getAllResult(start, end);
                break;
            default:
                //默认返回 null
                return null;
        }
        return resultList;
    }

    /**
     * 将10进制转为指定长度的二进制字符串
     *
     * @param decNum
     * @param digit
     * @return
     */
    public static String decimal2Binary(int decNum, int digit) {
        String binStr = "";
        for (int i = digit - 1; i >= 0; i--) {
            binStr += (decNum >> i) & 1;
        }
        return binStr;
    }


}
