package cn.com.duiba.kjy.api.util;

import org.apache.commons.collections.MapUtils;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Comparator;
import java.util.Objects;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 用于排序的工具
 * @author 吴文哲
 * @date 2019-09-06 15:03
 **/
public class SortUtil {

    /**
     * 排序工具
     *
     * @param id2ScoreMap id:唯一键 score:得分
     *
     * @return  返回一个以id为主键 值为排名的Map  同分数的排名顺序相同
     */
    public static Map<Long, Integer> sortMap(Map<Long, Integer> id2ScoreMap) {
        //排序
        Map<Long, Integer> sortedMap = new LinkedHashMap<>();
        id2ScoreMap.entrySet().stream().sorted(Comparator.comparing(e -> -e.getValue())).forEach(e -> sortedMap.put(e.getKey(), e.getValue()));
        //算出排名 分数相同排名相同
        Map<Long, Integer> sameScoreSortMap = new LinkedHashMap<>();
        //分数对应排名  key: 分数 value 标记该分数是否出现过
        Map<Integer, Integer> score2RankMap = new HashMap<>();
        //排名
        int rank = 0;
        for (Map.Entry<Long, Integer> entry : sortedMap.entrySet()) {
            rank++;
            //分数是否出现
            Integer _rank = score2RankMap.get(entry.getValue());
            if (_rank == null) {
                //没有出现过标记一下
                sameScoreSortMap.put(entry.getKey(), rank);
                score2RankMap.put(entry.getValue(), rank);
            } else {
                sameScoreSortMap.put(entry.getKey(), _rank);
            }
        }
        return sameScoreSortMap;
    }

    /**
     * 排序工具
     *
     * @param id2ScoreMap id:唯一键 score:得分
     *
     * @return  返回一个以id为主键 值为排名的Map  同分数的排名顺序相同
     *
     */
    public static Map<Long, Integer> sortMapForLongValue(Map<Long, Long> id2ScoreMap) {
       if(MapUtils.isEmpty(id2ScoreMap)){
           return new HashMap<>();
       }
       Map<Long,Integer> sortMap = new HashMap<>();
       List<Long> rankList = id2ScoreMap.values().stream().filter(e -> Objects.nonNull(e)).sorted(Comparator.comparing(e -> e.longValue())).collect(Collectors.toList());
       id2ScoreMap.keySet().stream().forEach(key -> {
           int index = rankList.indexOf(id2ScoreMap.get(key));
           if(index  < 0){
               sortMap.put(key,null);
           }else{
               sortMap.put(key,index+1);
           }
       });

       return sortMap;
    }

}
